sing System;
using System.Collections.Generic;
using System.Linq;

namespace Zadatak2
{
    public class Frilenser
    {
        public double Zarada { get; set; }
        public double Porez { get; set; }
    }

    class Program
    {
        static void Main(string[] args)
        {
            int brojFrilensera;
            if (!int.TryParse(Console.ReadLine(), out brojFrilensera))
            {
                Console.WriteLine("Morate uneti jedan ceo broj");
                Environment.Exit(-1);
            }


            var frilenseri = new List<Frilenser>(brojFrilensera);

            for (int i = 0; i < brojFrilensera; i++)
            {
                var inputArray = Console.ReadLine().Split(' ');
                if (inputArray.Length != 2)
                {
                    Console.WriteLine("Morate uneti dva broja - pocetnu platu i stopu poreza");
                    Environment.Exit(-1);
                }

                double zarada;
                double porez;

                if (!double.TryParse(inputArray[0], out zarada))
                {
                    Console.Write("Morate uneti dva broja");
                    Environment.Exit(-1);
                }

                if (!double.TryParse(inputArray[1], out porez))
                {
                    Console.Write("Morate uneti dva broja");
                    Environment.Exit(-1);
                }

                frilenseri.Add(new Frilenser
                {
                    Zarada = zarada,
                    Porez = porez
                });
            }


            double maxZarada = 0;
            double maxPorez = 0;


            foreach(var frilenser in frilenseri)
            {
                var porez = frilenser.Porez;

                var potencijalnaZarada = frilenseri
                    .Where(x => x.Porez >= porez)
                    .Select(x => x.Zarada * (porez / 100))
                    .Sum();


                if (potencijalnaZarada > maxZarada)
                {
                    maxZarada = potencijalnaZarada;
                    maxPorez = porez;
                }
            }

            Console.WriteLine(maxPorez);
        }
    }
}